#include "Repetier.h"
#include "Printer.h"
void execmd(char *cmds)
{
	Com::printF(PSTR("Executing: "));
	Com::print(cmds);
	Com::printF(PSTR("\n"));
	GCode code;
	code.parseAscii(cmds, false);
	Commands::executeGCode(&code);
}

void SetThermal(int temp, bool wait)
{
#ifdef DISABLE_AUTO_THERMAL_SET
	Com::printF(PSTR("Global Thermal Configure Function is Disable!\n"));
	return;
#else
	char buff[128];
	//Set Temp
	for (int n = 0; n < NUM_EXTRUDER; n++)
	{
		memset(buff, '\0', 128);
		sprintf(buff, "M104 T%d S%d", n, temp);
		execmd(buff);
	}
	//Wait Temp
	if (wait)
		for (int n = 0; n < NUM_EXTRUDER; n++)
		{
			memset(buff, '\0', 128);
			sprintf(buff, "M109 T%d S%d", n, temp);
			execmd(buff);
		}
	else
		Com::printF(PSTR("Set No Wait for Thermal Ready..."));
#endif
}

void DisableThermal()
{
	Commands::waitUntilEndOfAllMoves();
	SetThermal(0, false);
}

extern int SpeedSteps = 1;

String GetCurrentVersion()
{
	char ret[64];
	char mirror_stat[2] = { 'F','\0' };
#ifdef IU_FIX_MIRROR_PROBLEM
	mirror_stat[0] = 'M';
#endif
	sprintf(ret, "IT%sTNEB%NEL%02x-%04x",
		mirror_stat,
		(unsigned char)IU_LANG_PROFILE,
		(unsigned int)FIRMWARE_VERSION);
	return strupr(ret);
}
millis_t last_back_time = -1;
void StopBack()
{
	if (last_back_time != -1 && abs(millis() - last_back_time) < 5 * 1000)
		return;
	last_back_time = millis();
#ifdef IU_HAVE_AUTOBACK
	if (Printer::convertToMM(Printer::lastCmdPos[Z_AXIS]) < 90)
	{
		char buff[128] = { 0x00 };
		sprintf(buff, "G0 Z%d", (int)(Printer::convertToMM(Printer::lastCmdPos[Z_AXIS])) + 10);
		Com::printFLN(buff);
		execmd(buff);
	}
#endif
	Printer::homeXAxis();
#ifdef IU_HAVE_PGMEND_REBACK
	Com::printFLN("Auto Program Back Enabled!");
	char buff[128];
#define RESET_BUFF() memset(buff,0,sizeof(buff))

#ifdef IU_PGMEND_REBACK_HEAT
	if (!Extruder::getTempDiff(0) > 10)
		SetThermal(Extruder::getTargetTemp(0));
#endif
	execmd((char *)"G91");
	sprintf(buff, "G1 E-%d F%d", IU_PGMEND_REBACK_LEN, IU_REBACK_SPEED);
	execmd(buff);
	execmd((char *)"G90");
	Commands::waitUntilEndOfAllMoves();
	DisableThermal();
#endif
	Commands::waitUntilEndOfAllMoves();
	Printer::setAllSteppersDiabled();
	Printer::disableXStepper();
	Printer::disableYStepper();
	Printer::disableZStepper();
	Extruder::disableAllExtruderMotors();
}